#ifndef __YC_CIOCTL_H__
#define __YC_CIOCTL_H__

/***************************************************************
 *                command ioctl ӿ                           *
 *            ں˺û̬                       *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2014 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


/* ģʽ(operate mode) */
#define YC_CIOCTL_CMD_OP_GET	    0x0/* (set) */
#define YC_CIOCTL_CMD_OP_SET	    0x1/* ȡ(get) */
#define YC_CIOCTL_CMD_OP_BOTH	    0x2/* òȡ(set and get) */

/* ֣ռ8λռ8λģʽռ2λռ14λ
   (define command, name 8bit, type 8bit, operate 2bit, command 14bit) */
#define YC_CIOCTL_CMD_DEFINE(name, type, operate, command)		\
                                    ((name) << 24) |\
                                    ((type) << 16) |\
                                    ((operate) << 14) |\
                                    (command)


#ifndef KERNEL

/* ں(local kernel) */
#define YC_CIOCTL_LOCAL	            NULL

/*****************************************************************************
   (Prototype)    : yc_cioctl_init
 (Description)  : ʼcioctlģ飬ʹyc_cioctl֮ǰȳʼ
 (Input)        : (None)
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/6/30
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cioctl_init(void);

/*****************************************************************************
   (Prototype)    : yc_cioctl_fini
 (Description)  : ȥʼcioctlģ
 (Input)        : (None)
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/6/30
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_cioctl_fini(void);

/*****************************************************************************
   (Prototype)    : yc_cioctl
 (Description)  : ں˷/ȡݣһͬӿ
 (Input)        : uiCmd           
                          pcDstIP         ĿĵַںΪYC_CIOCTL_LOCAL
                          pInData         ͵
                          uiInDataLen     ݵĳ
                          uiOutBufLen     ȡݻ
 (Output)       : pOutBuf         ȡݻ
                          puiOutDataLen   õݳ
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/6/30
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cioctl(IN uint uiCmd,     IN const char *pcDstIP,
              IN void *pInData,  IN uint uiInDataLen,
              OUT void *pOutBuf, IN uint uiOutBufLen,
              OUT uint *puiOutDataLen);

/*****************************************************************************
   (Prototype)    : yc_cioctl_asyn
 (Description)  : ں˷/ȡݣһ첽ӿ
 (Input)        : uiCmd           
                          pcDstIP         ĿĵַںΪYC_CIOCTL_LOCAL
                          pInData         ͵
                          uiInDataLen     ݵĳ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/6/30
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cioctl_asyn(IN uint uiCmd,    IN const char *pcDstIP,
                   IN void *pInData, IN uint uiInDataLen);

#else /* KERNEL */

/*****************************************************************************
   (Prototype)    : yc_cioctl_proc_pf
 (Description)  : ںдֵĻص
 (Input)        : pInData           
                          uiInDataLen       ݳ
                          uiOutBufLen       
 (Output)       : pOutBuf           
                          puiOutDataLen     ݳ
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/6/29
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef int (*yc_cioctl_proc_pf)(IN const void *pInData, IN uint uiInDataLen,
                                 OUT void *pOutBuf,      IN uint uiOutBufLen,
                                 OUT uint *puiOutDataLen);

/*****************************************************************************
   (Prototype)    : yc_cioctl_register
 (Description)  : ںעһֵĻص
 (Input)        : uiCmd           
                          pfProcFunc      ֵĻص
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/6/29
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cioctl_register(IN uint uiCmd, IN yc_cioctl_proc_pf pfProcFunc);

/*****************************************************************************
   (Prototype)    : yc_cioctl_deregister
 (Description)  : ɾںдֵĻص
 (Input)        : uiCmd           
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/6/29
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_cioctl_deregister(IN uint uiCmd);

#endif /* KERNEL */

#endif /* __YC_CIOCTL_H__ */

