#ifndef __YC_CLI_H__
#define __YC_CLI_H__

/***************************************************************
 *              command line ؽӿ                          *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2016 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


/*****************************************************************************
   (Prototype)    : yc_cli_cmd_callback
 (Description)  : ִлص
 (Input)        : pPriv        ص˽в
                          pcArg        ݸصĲҪصн
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_EXIT    ˳cli(exit cli)
                                    other            (normal run)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef int (*yc_cli_cmd_callback)(IN void *pPriv, IN char *pcArg);

typedef struct tagCli_CmdHandle
{
    char *pcCmdName;
    yc_cli_cmd_callback pfHandle;
    void *pPriv;
}yc_cli_cmd_s;

/*****************************************************************************
   (Prototype)    : yc_cli_create
 (Description)  : 
 (Input)        : pcPrompt        ʾ
 (Output)       : (None)
   ֵ(Return Value) : int             YC_ERROR_SUCCESS    ɹ(success)
                                          other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cli_create(IN const char *pcPrompt);

/*****************************************************************************
   (Prototype)    : yc_cli_add_cmd
 (Description)  : Ϊһ
 (Input)        : pcCmdName         
                          pfCmdHandle       ص
                          pPriv             ص˽в
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS      ɹ(success)
                                    other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cli_add_cmd(IN const char *pcCmdName,
                   IN yc_cli_cmd_callback pfCmdHandle,
                   IN void *pPriv);

/*****************************************************************************
   (Prototype)    : yc_cli_add_cmd_batch
 (Description)  : Ϊ
 (Input)        : pstCmd         
                          uiCount        
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS      ɹ(success)
                                    other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cli_add_cmd_batch(IN yc_cli_cmd_s *pstCmd[], IN uint uiCount);

/*****************************************************************************
   (Prototype)    : yc_cli_del_cmd
 (Description)  : ɾһ
 (Input)        : pcCmdName         
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS      ɹ(success)
                                    other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cli_del_cmd(IN const char *pcCmdName);

/*****************************************************************************
   (Prototype)    : yc_cli_run
 (Description)  : Уִие߳̽᷵أ
                          ڻص˳ֵYC_ERROR_EXIT˳ã
                          bIsNewThrdǷǰ̣߳
                          ڽһ"exitcli"˳
 (Input)        : bIsNewThrd        Ƿִ߳и
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_EXIT         ˳(exit cli)
                                    other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_cli_run(IN bool_t bIsNewThrd);

/*****************************************************************************
   (Prototype)    : yc_cli_destroy
 (Description)  : ִлص
 (Input)        : (None)
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_cli_destroy(void);

#endif /* __YC_CLI_H__ */

