#ifndef __YC_REG_H__
#define __YC_REG_H__

/***************************************************************
 *          û Ĵ(ڴ)ӿ                    *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2016 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


#ifndef YC_BIT
#define YC_BIT(x)  (1 << (x))
#endif

#ifndef YC_READ_REG32
#define YC_READ_REG32(addr)               (*((volatile uint *)(addr)))
#endif

#ifndef YC_WRITE_REG32
#define YC_WRITE_REG32(addr, value)       ((*((volatile uint *)(addr))) = (value))
#endif

#ifndef YC_GET_BIT_FOR_U32
#define YC_GET_BIT_FOR_U32(value, bit)    (((value) & YC_BIT(bit)) >> (bit))
#endif

#ifndef YC_SET_BIT_0_FOR_U32
#define YC_SET_BIT_0_FOR_U32(value, bit)  ((value) & (~(YC_BIT(bit))))
#endif

#ifndef YC_SET_BIT_1_FOR_U32
#define YC_SET_BIT_1_FOR_U32(value, bit)  ((value) | YC_BIT(bit))
#endif

/*****************************************************************************
   (Prototype)    : yc_read_reg32
 (Description)  : ȡһ32λĴ
 (Input)        : uiAddr    Ĵַ
 (Output)       : (None)
   ֵ(Return Value) : uint      Ĵֵ

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/8
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
uint yc_read_reg32(IN uint uiAddr);

/*****************************************************************************
   (Prototype)    : yc_write_reg32
 (Description)  : дһ32λĴ
 (Input)        : uiAddr    Ĵַ
                          uiValue   ҪдĴֵ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/8
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_write_reg32(IN uint uiAddr, IN uint uiValue);

/*****************************************************************************
   (Prototype)    : yc_mmap
 (Description)  : Թʽӳһڴ棬ûռַ
 (Input)        : uiAddr    ڴʼַ
                          uiSize    Ҫӳڴ泤
 (Output)       : (None)
   ֵ(Return Value) : void*     YC_INVALID_HANDLE       ʧ(fail)
                                    other                   ɹ(success)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/8
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void *yc_mmap(IN uint uiAddr, IN uint uiSize);

/*****************************************************************************
   (Prototype)    : yc_munmap
 (Description)  : ڴӳ
 (Input)        : pMem          ûռַ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/8
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_munmap(IN void *pMem);

#endif /* __YC_REG_H__ */

