#ifndef __YC_SSL_H__
#define __YC_SSL_H__

/***************************************************************
 *                  ssl ؽӿ                               *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2016 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


typedef struct tagSsl_Handle yc_ssl_s;

/*****************************************************************************
   (Prototype)    : yc_ssl_connect
 (Description)  : sslӣ֤
 (Input)        : pcHost        ַ
                          usPort        ˿
 (Output)       : (None)
   ֵ(Return Value) : yc_ssl_s*      !NULL    ɹ(success)
                                          NULL    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_ssl_s *yc_ssl_connect(IN const char *pcHost, IN ushort usPort);

/*****************************************************************************
   (Prototype)    : yc_ssl_connect2
 (Description)  : sslӣ֤ΪPEMʽڴֱӶȡ
 (Input)        : pcHost                ַ
                          usPort                ˿
                          pcUserCert            û֤
                          uiUserCertLen         û֤鳤
                          pcUserPrvi            û˽Կ
                          uiUserPrviLen         û˽Կ
                          pcCaCert              Կ֤
                          uiCaCertLen           Կ֤鳤
 (Output)       : (None)
   ֵ(Return Value) : yc_ssl_s*      !NULL    ɹ(success)
                                          NULL    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_ssl_s *yc_ssl_connect2(IN const char *pcHost,
                          IN ushort usPort,
                          IN const char *pcUserCert,
                          IN uint uiUserCertLen,
                          IN const char *pcUserPrvi,
                          IN uint uiUserPrviLen,
                          IN const char *pcCaCert,
                          IN uint uiCaCertLen);

/*****************************************************************************
   (Prototype)    : yc_ssl_connect3
 (Description)  : sslӣ֤ΪPEMʽļжȡ
 (Input)        : pcHost                ַ
                          usPort                ˿
                          pcUserCert            û֤ļ
                          pcUserPrvi            û˽Կļ
                          pcCaCert              Կ֤ļ
 (Output)       : (None)
   ֵ(Return Value) : yc_ssl_s*      !NULL    ɹ(success)
                                          NULL    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_ssl_s *yc_ssl_connect3(IN const char *pcHost,
                          IN ushort usPort,
                          IN const char *pcUserCert,
                          IN const char *pcUserPrvi,
                          IN const char *pcCaCert);

/*****************************************************************************
   (Prototype)    : yc_ssl_write
 (Description)  : ssl
 (Input)        : pSsl          ssl
                          pData         Ҫ͵
                          uiDataLen     Ҫ͵ݳ
 (Output)       : (None)
   ֵ(Return Value) : int           >0      ʵʷ͵ĳ(actually length)
                                       <=0      ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_ssl_write(IN yc_ssl_s *pSsl, IN const void *pData, IN uint uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_ssl_read
 (Description)  : ȡssl
 (Input)        : pSsl          ssl
                          uiBufLen      ջ
 (Output)       : pBuf          ջ
   ֵ(Return Value) : int           >0     ȡݳ(recved length)
                                       ==0     (EOF)
                                        <0     ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_ssl_read(IN yc_ssl_s *pSsl, OUT void *pBuf, IN uint uiBufLen);

/*****************************************************************************
   (Prototype)    : yc_ssl_close
 (Description)  : رһssl
 (Input)        : pSsl          ssl
 (Output)       : (None)
   ֵ(Return Value) : int      YC_ERROR_SUCCESS    ɹ(success)
                                   YC_ERROR_FAILED     ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/4
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_ssl_close(IN yc_ssl_s *pSsl);

#endif /* __YC_SSL_H__ */

