#ifndef __YC_TIMER_H__
#define __YC_TIMER_H__

/***************************************************************
 *                  ʱӿ                             *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2014 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


/* ================== 1.ͨʱ ================================= */

/* Чtimer id */
#define YC_TIMER_ID_INVALID          YC_INVALID_HANDLE

/*****************************************************************************
   (Prototype)    : yc_timer_callback_pf
 (Description)  : ʱʱ
 (Input)        : arg           ʱص˽в
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef void (*yc_timer_callback_pf)(IN void *arg);

typedef enum yc_timer_unit_type {
    TIMER_UNIT_SC = 0,  /*    */
    TIMER_UNIT_MS,      /* 뼶 */
    TIMER_UNIT_US,      /* ΢뼶 */
    TIMER_UNIT_NS       /* 뼶 */
}yc_timer_unit_e;


/*****************************************************************************
   (Prototype)    : yc_timer_add
 (Description)  : ʱÿֻܴ߳һ
 (Input)        : bIsLoop           ѭͷѭʱ
                          enUnit            ʱʱ侫
                          interval          ʱ
                          callback          ʱص
                          arg               ʱصΪ
 (Output)       : (None)
   ֵ(Return Value) : ʱ     YC_TIMER_ID_INVALID     ʧ(fail)
                                        !YC_TIMER_ID_INVALID     ɹ(success)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void *yc_timer_add(IN bool_t bIsLoop,
                   IN yc_timer_unit_e enUnit, IN int interval,
                   IN yc_timer_callback_pf callback, IN void *arg);

/*****************************************************************************
   (Prototype)    : yc_timer_mod
 (Description)  : ʱ޸ĺ޸֮¼ʱ
 (Input)        : pTmHd             ʱ
                          bIsLoop           ѭͷѭʱ
                          enUnit            ʱʱ侫
                          interval          ʱ
 (Output)       : (None)
   ֵ(Return Value) : int        YC_ERROR_SUCCESS     ɹ(success)
                                     other                ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_timer_mod(IN void *pTmHd,
                 IN bool_t bIsLoop,
                 IN yc_timer_unit_e enUnit,
                 IN int interval);

/*****************************************************************************
   (Prototype)    : yc_timer_get_remain_time
 (Description)  : ȡʱʣʱ䣬λ
 (Input)        : pTmHd             ʱ
 (Output)       : (None)
   ֵ(Return Value) : long       YC_ERROR_FAILED     ʧ(fail)
                                     other               ɹ(success)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
long yc_timer_get_remain_time(IN void *pTmHd);

/*****************************************************************************
   (Prototype)    : yc_timer_del
 (Description)  : ɾʱ
 (Input)        : pTmHd             ʱ
 (Output)       : (None)
   ֵ(Return Value) : int        YC_ERROR_SUCCESS     ɹ(success)
                                     other                ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_timer_del(IN void *pTmHd);



/* ================== 2.Ӷʱ ================================= */

/* Ч */
#define YC_ALARM_INVALID          0xFFFFFFFF

/*****************************************************************************
   (Prototype)    : yc_alarm_callback
 (Description)  : ӳʱ
 (Input)        : p           ӻص˽в
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef void (*yc_alarm_callback)(IN void *p);

/*****************************************************************************
   (Prototype)    : yc_set_alarm
 (Description)  : ӣÿֻһ
 (Input)        : seconds           ʱ䵥λΪ룬Ϊ0ȡ
                          bIsLoop           ѭͷѭ
                          pfCallback        ӳʱ
                          pArg              ӻص˽в
 (Output)       : (None)
   ֵ(Return Value) : uint  YC_ALARM_INVALID        ô(error)
                                other   һʣʱ䣬Ϊ0˵һ

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
uint yc_set_alarm(IN uint seconds,
                  IN bool_t bIsLoop,
                  IN yc_alarm_callback pfCallback, IN void *pArg);



/* ================ 3.ļʱ ============================ */

/*****************************************************************************
   (Prototype)    : yc_timerfd_add
 (Description)  : ʱ
                          ʹepoll/selectȼʹcloseرգ
 (Input)        : bIsLoop      ѭͷѭʱ
                          enUnit       ʱʱ侫
                          interval     ʱ䣬Ϊ0ֻfdʱ䣬ʱʼת
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_FAILED    ʧ(fail)
                                    other              ʱļ(fd)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_timerfd_add(IN bool_t bIsLoop,
                   IN yc_timer_unit_e enUnit, IN int interval);

/*****************************************************************************
   (Prototype)    : yc_timerfd_mod
 (Description)  : /޸Ķʱʱ
 (Input)        : iFd          ʱļ
                          bIsLoop      ѭͷѭʱ
                          enUnit       ʱʱ侫
                          interval     ʱ䣬Ϊ0ֻfdʱ䣬ʱʼת
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS       ɹ(success)
                                    other                  ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_timerfd_mod(IN int iFd,
                   IN bool_t bIsLoop,
                   IN yc_timer_unit_e enUnit, IN int interval);

/*****************************************************************************
   (Prototype)    : yc_timerfd_get_remain_time
 (Description)  : ȡʱʣʱ䣬λ
 (Input)        : iFd       ʱļ
 (Output)       : (None)
   ֵ(Return Value) : long      YC_ERROR_FAILED     ʧ(fail)
                                    other               ʣʱ(remain times)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/11/16
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
long yc_timerfd_get_remain_time(IN int iFd);

#endif /* __YC_TIMER_H__ */

