/***************************************************************************** 

GND
VCC  3.3v

D0   CLK       --- WM_IO_PA_01
D1   MOSI      --- WM_IO_PB_18
CS             --- WM_IO_PB_07

RES            --- WM_IO_PB_11   
DC   cmd/data  --- WM_IO_PB_10

*****************************************************************************/ 
#include <time.h>
#include <stdarg.h>
#include <string.h>

#include "wm_include.h"
#include "wm_netif2.0.3.h"
#include "wm_rtc.h"
#include "wm_ntp.h"
#include "wm_http_fwup.h"
#include "wm_wifi_oneshot.h"
#include "cJSON.h"
#include "utils.h"

#include "zlib.h"
#include "zutil.h"
#include "inftrees.h"
#include "inflate.h"

#include "oled/oled.h"
#include "oled/bmp.h"

/* ͷapi, Լȥעһkey */
//#define WEATHER_URL "https://free-api.heweather.net/s6/weather/now?location=auto_ip&key=077c4538803a4fe4aa71c7d621bbc8e8"
#define WEATHER_URL "https://devapi.qweather.com/v7/weather/now?location=101110101&key=077c4538803a4fe4aa71c7d621bbc8e8&lang=en&gzip=n"

#define USER_BUFFER_SIZE            256
#define HTTP_CLIENT_BUFFER_SIZE     4096

#define USER_KEY                    WM_IO_PA_00

#define OLED_TASK_PRIO              33
#define OLED_TASK_STK_SIZE          2048

static OS_STK oled_task_stk[OLED_TASK_STK_SIZE];

static u8 oled_str[USER_BUFFER_SIZE];

static char *temp_str = NULL;
//static int cond_code = 0;
static char *text_str = NULL;

extern void tls_sys_auto_mode_run(void);

static void ntp_updata_time(void)
{
    unsigned int t;
    struct tm *tblock;

    t = tls_ntp_client();

    printf("now Time: %s", ctime(&t));
    tblock = localtime(&t);
    tls_set_rtc(tblock);

    return;
}

#include "zlib.h"

static int network_gzip_decompress(void *in_buf, size_t in_size, void *out_buf, size_t *out_size, size_t out_buf_size)
{
    int err = 0;
    z_stream d_stream = {0}; /* decompression stream */
    d_stream.zalloc = NULL;
    d_stream.zfree = NULL;
    d_stream.opaque = NULL;
    d_stream.next_in  = in_buf;
    d_stream.avail_in = 0;
    d_stream.next_out = out_buf;

    if((err=inflateInit2(&d_stream, 47)) != Z_OK) {
        return err;
    }
    while(d_stream.total_out < out_buf_size-1 && d_stream.total_in < in_size) {
        d_stream.avail_in = d_stream.avail_out = 1;
        if((err = inflate(&d_stream, Z_NO_FLUSH)) == Z_STREAM_END) {
            break;
        }
        if(err != Z_OK) {
            return err;
        }
    }

    if((err=inflateEnd(&d_stream)) != Z_OK) {
        return err;
    }

    *out_size = d_stream.total_out;
    ((char*)out_buf)[*out_size] = '\0';

    return Z_OK;
}

/* Uncompress gzip data */
/* zdata  nzdata ԭݳ data ѹ ndata ѹ󳤶 */
int gzdecompress(Byte *zdata, uLong nzdata,
                 Byte *data, uLong *ndata)
{
    int err = 0;
    z_stream d_stream = { 0 }; /* decompression stream */
    static char dummy_head[2] = {
        0x8 + 0x7 * 0x10,
        (((0x8 + 0x7 * 0x10) * 0x100 + 30) / 31 * 31) & 0xFF,
    };
    d_stream.zalloc = NULL;
    d_stream.zfree = NULL;
    d_stream.opaque = NULL;
    d_stream.next_in = zdata;
    d_stream.avail_in = 0;
    d_stream.next_out = data;
    //ֻΪMAX_WBITS + 16ڽѹheadertrailerı
    if (inflateInit2(&d_stream, MAX_WBITS + 16) != Z_OK) return -1;
    //if(inflateInit2(&d_stream, 47) != Z_OK) return -1;
    while (d_stream.total_out < *ndata && d_stream.total_in < nzdata) {
        d_stream.avail_in = d_stream.avail_out = 1; /* force small buffers */
        if ((err = inflate(&d_stream, Z_NO_FLUSH)) == Z_STREAM_END) break;
        if (err != Z_OK) {
            if (err == Z_DATA_ERROR) {
                d_stream.next_in = (Bytef*)dummy_head;
                d_stream.avail_in = sizeof(dummy_head);
                if ((err = inflate(&d_stream, Z_NO_FLUSH)) != Z_OK) {
                    return -1;
                }
            }
            else return -1;
        }
    }
    if (inflateEnd(&d_stream) != Z_OK) return -1;
    *ndata = d_stream.total_out;
    return 0;
}

static void query_weather_info(void)
{
    int                   nRetCode;
    u32                   nSize, nTotal = 0;
    char                 *Buffer = NULL;
    char                 *Buffer2 = NULL;
    HTTP_SESSION_HANDLE   pHTTP;
    u8                    is_gzip = 0;

    do
    {
        Buffer = (char *)tls_mem_alloc(HTTP_CLIENT_BUFFER_SIZE);
        if(Buffer == NULL)
        {
            return;// HTTP_CLIENT_ERROR_NO_MEMORY;
        }
        memset(Buffer, 0, HTTP_CLIENT_BUFFER_SIZE);
        // Open the HTTP request handle
        pHTTP = HTTPClientOpenRequest(0);
        if(!pHTTP)
        {
            nRetCode =  HTTP_CLIENT_ERROR_INVALID_HANDLE;
            break;
        }

        //HTTPClientAddRequestHeaders(pHTTP, "Accept-Encoding", "identity", 1);

        // Set the Verb
        nRetCode = HTTPClientSetVerb(pHTTP, VerbGet);
        if(nRetCode != HTTP_CLIENT_SUCCESS)
        {
            break;
        }
        if((nRetCode = HTTPClientSendRequest(pHTTP, WEATHER_URL, NULL, 0, 0, 0, 0)) != HTTP_CLIENT_SUCCESS)
        {
            break;
        }
        // Retrieve the the headers and analyze them
        if((nRetCode = HTTPClientRecvResponse(pHTTP, 30)) != HTTP_CLIENT_SUCCESS)
        {
            break;
        }

        nSize = HTTP_CLIENT_BUFFER_SIZE - 1;
        if(HTTPClientFindFirstHeader(pHTTP, "Content-Encoding", Buffer, &nSize) == HTTP_CLIENT_SUCCESS)
        {
            printf("Server resp format: %s\n", Buffer + strlen("Content-Encoding: "));
            if (strstr(Buffer, "gzip"))
                is_gzip = 1;
        }

        printf("Start to receive data from remote server...\r\n");

        nSize = 0;
        memset(Buffer, 0, HTTP_CLIENT_BUFFER_SIZE);

        // Get the data until we get an error or end of stream code
        while(nRetCode == HTTP_CLIENT_SUCCESS || nRetCode != HTTP_CLIENT_EOS)
        {
            // Set the size of our buffer
            nSize = HTTP_CLIENT_BUFFER_SIZE - nTotal;
            // Get the data
            nRetCode = HTTPClientReadData(pHTTP, Buffer + nTotal, nSize, 300, &nSize);
            if(nRetCode != HTTP_CLIENT_SUCCESS && nRetCode != HTTP_CLIENT_EOS)
                break;
            nTotal += nSize;
        }
    } while (0);

    printf("HTTP Client terminated %d (got %d b)\r\n", nRetCode, nTotal);

    if (is_gzip)
    {
        Buffer2 = (char *)tls_mem_alloc(nTotal);
        if(Buffer2 == NULL)
        {
            goto end;
        }
        memcpy(Buffer2, Buffer, nTotal);
        nSize = HTTP_CLIENT_BUFFER_SIZE - 1;
        int ret = network_gzip_decompress(Buffer2, nTotal, Buffer, &nSize, HTTP_CLIENT_BUFFER_SIZE - 1);
        //int ret = gzdecompress(Buffer2, nTotal, Buffer, &nSize);
        tls_mem_free(Buffer2);

        printf("degzip = %d, len %d\r\n", ret, nSize);

        if (!ret) nTotal = nSize;
    }

    printf("Buffer = '%s'\r\n", Buffer);

    if ((HTTP_CLIENT_EOS == nRetCode) && (nTotal > 0))
    {
        cJSON *json;
        cJSON *node;
        cJSON *data;
        json = cJSON_Parse(Buffer);
        if (json)
        {
            node = cJSON_GetObjectItem(json, "now");
            if (node)
            {
                data = cJSON_GetObjectItem(node, "temp");
                if (data)
                {
                    printf("temp = [%s]\r\n", data->valuestring);
                    if (temp_str)
                        tls_mem_free(temp_str);
                    temp_str = strdup(data->valuestring);
                }

                data = cJSON_GetObjectItem(node, "text");
                if (data)
                {
                    printf("text = [%s]\r\n", data->valuestring);
                    //cond_code = atoi(data->valuestring);
                    if (text_str)
                        tls_mem_free(text_str);
                    text_str = strdup(data->valuestring);
                }
            }

            cJSON_Delete(json);
        }
    }

end:
    tls_mem_free(Buffer);

    if(pHTTP)
        HTTPClientCloseRequest(&pHTTP);

    return;
}

static void init_wifi_config(void)
{
    u8 wireless_protocol = 0;
    u8 auto_reconnect = 0xff;
    struct tls_param_ip *ip_param = NULL;

    tls_param_get(TLS_PARAM_ID_WPROTOCOL, (void *) &wireless_protocol, TRUE);
    if (TLS_PARAM_IEEE80211_INFRA != wireless_protocol)
    {
        tls_wifi_softap_destroy();
        wireless_protocol = TLS_PARAM_IEEE80211_INFRA;
        tls_param_set(TLS_PARAM_ID_WPROTOCOL, (void *) &wireless_protocol, FALSE);
    }

    ip_param = tls_mem_alloc(sizeof(struct tls_param_ip));
    if (ip_param)
    {
        tls_param_get(TLS_PARAM_ID_IP, ip_param, FALSE);
        ip_param->dhcp_enable = TRUE;
        tls_param_set(TLS_PARAM_ID_IP, ip_param, FALSE);
        tls_mem_free(ip_param);
    }

    tls_wifi_auto_connect_flag(WIFI_AUTO_CNT_FLAG_GET, &auto_reconnect);
    if (WIFI_AUTO_CNT_ON != auto_reconnect)
    {
        auto_reconnect = WIFI_AUTO_CNT_ON;
        tls_wifi_auto_connect_flag(WIFI_AUTO_CNT_FLAG_SET, &auto_reconnect);
        tls_sys_auto_mode_run();
    }
}

static void update_oled_time(void)
{
    struct tm tblock;

    tls_get_rtc(&tblock);

    sprintf((char*)oled_str, "%02d.%02d %02d:%02d:%02d", 
                             tblock.tm_mon + 1, tblock.tm_mday, 
                             tblock.tm_hour, tblock.tm_min, tblock.tm_sec);

    OLED_ShowString(0, 0, oled_str);
}

static void update_oled_weather(void)
{
    char *cond_str;

    sprintf((char*)oled_str, "temperature: %s", temp_str ? temp_str : "-");

    OLED_ShowString(0, 3, oled_str);

#if 0
    if (cond_code == 100)
        cond_str = "clear";
    else if (cond_code > 100 && cond_code < 104)
        cond_str = "cloudy";
    else if (cond_code == 104)
        cond_str = "overcast";
    else if (cond_code >= 200 && cond_code < 300)
        cond_str = "windy";
    else if (cond_code >= 300 && cond_code < 400)
        cond_str = "rain";
    else if (cond_code >= 400 && cond_code < 500)
        cond_str = "snow";
    else if (cond_code >= 500 && cond_code < 600)
        cond_str = "fog";
    else if (cond_code == 900)
        cond_str = "hot";
    else if (cond_code == 901)
        cond_str = "cold";
    else
        cond_str = "-";//"unknown";
#else
    cond_str = text_str;
#endif

    sprintf((char*)oled_str, "weather: %s", cond_str);

    OLED_ShowString(0, 6, oled_str);
}

static void led_init(void)
{
    tls_gpio_cfg(WM_IO_PB_14, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_15, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_16, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_17, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLHIGH);

    tls_gpio_write(WM_IO_PB_14, 0);
    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_14, 1);
    tls_gpio_write(WM_IO_PB_15, 0);
    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_15, 1);
    tls_gpio_write(WM_IO_PB_16, 0);
    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_16, 1);
    tls_gpio_write(WM_IO_PB_17, 0);
    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_17, 1);

    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_17, 0);
    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_17, 1);
    tls_gpio_write(WM_IO_PB_16, 0);
    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_16, 1);
    tls_gpio_write(WM_IO_PB_15, 0);
    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_15, 1);
    tls_gpio_write(WM_IO_PB_14, 0);
    tls_os_time_delay(HZ / 2);
    tls_gpio_write(WM_IO_PB_14, 1);
}

static void oled_task(void *data)
{
    u32 start;
    u32 end;
    u32 cnt = 30 * 60;

    OLED_Init();
    OLED_Clear();
    OLED_DrawBMP(0, 0, 128, 8, BMP1);

    led_init();

    tls_gpio_cfg(USER_KEY, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);

    //init_wifi_config();

    struct tls_ethif *ethif;
    ethif = tls_netif_get_ethif();

    for( ; ; ) 
	{
        start = tls_os_get_time();
        while (!tls_gpio_read(USER_KEY));
        end = tls_os_get_time();

        if ((end - start) >= (3 * HZ))
        {
            printf("enter oneshot\n");
            tls_wifi_set_oneshot_config_mode(0);
            tls_wifi_set_oneshot_flag(1);

            OLED_Clear();
            OLED_ShowString(0, 3, "config...");

            while (tls_wifi_get_oneshot_flag())
                tls_os_time_delay(HZ);

            cnt = 30 * 60;
        }

        if (ethif->status)
        {
            if (cnt >= (30 * 60))
            {
                OLED_Clear();
                OLED_ShowString(0, 3, "update...");
            
                ntp_updata_time();
                update_oled_time();

                query_weather_info();
                update_oled_weather();

                cnt = 0;
            }
            else
            {
                update_oled_time();
            }

            cnt++;
        }
        else
        {
            OLED_Clear();
            OLED_ShowString(0, 3, "connecting...");
        }

        tls_os_time_delay(HZ);
	}
}

void UserMain(void)
{
    printf("\n\noled weather demo\n");

    tls_os_task_create(NULL, NULL, oled_task,
                       (void *)0, (void *)oled_task_stk,
                       OLED_TASK_STK_SIZE * sizeof(u32),
                       OLED_TASK_PRIO, 0);
}

