/*
 * airkiss.h
 *
 *  Created on: 2015-1-26
 *      Author: peterfan
 */

#ifndef AIRKISS_H_
#define AIRKISS_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 * AIRKISS_ENABLE_CRYPTΪ1AirKissܹ
 */
#ifndef AIRKISS_ENABLE_CRYPT
#define AIRKISS_ENABLE_CRYPT 0
#endif


typedef void* (*airkiss_memset_fn) (void* ptr, int value, unsigned int num);
typedef void* (*airkiss_memcpy_fn) (void* dst, const void* src, unsigned int num);
typedef int (*airkiss_memcmp_fn) (const void* ptr1, const void* ptr2, unsigned int num);
typedef int (*airkiss_printf_fn) (const char* format, ...);


/*
 * AirKissãĿǰһЩص
 */
typedef struct
{
	/*
	 * Ϊٿļc׼⺯Ҫϲʹṩ
	 * printfΪNULL
	 */
	airkiss_memset_fn memset;
	airkiss_memcpy_fn memcpy;
	airkiss_memcmp_fn memcmp;
	airkiss_printf_fn printf;

} airkiss_config_t;



/*
 * AirKiss APIҪĽṹ壬Ϊȫֱͨmalloc̬
 */
typedef struct
{
	int dummyap[26];
	int dummy[32];
} airkiss_context_t;



/*
 * AirKissɹĽ
 */
typedef struct
{
	char* pwd;						/* wifi룬'\0'β */
	char* ssid;						/* wifi ssid'\0'β */
	unsigned char pwd_length;		/* wifi볤 */
	unsigned char ssid_length;		/* wifi ssid */
	unsigned char random;			/* ֵAirKissЭ飬wifiӳɹҪͨudp10000˿ڹ㲥ֵAirKissͶˣ΢ſͻ˻AirKissDebugger֪AirKissóɹ */
	unsigned char reserved;			/* ֵ */
} airkiss_result_t;



/*
 * airkiss_recv()µķֵ
 */
typedef enum
{
	/* ⴦airkiss_recv()ֱɹ */
	AIRKISS_STATUS_CONTINUE = 0,

	/* wifiŵѾϲӦֹͣлŵ */
	AIRKISS_STATUS_CHANNEL_LOCKED = 1,

	/* ɹԵairkiss_get_result()ȡý */
	AIRKISS_STATUS_COMPLETE = 2

} airkiss_status_t;



#if AIRKISS_ENABLE_CRYPT

/*
 * ýkeyΪ128bitkey128bitĬ0
 *
 * ֵ
 * 		< 0ͨǲ
 * 		  0ɹ
 */
int airkiss_set_key(airkiss_context_t* context, const unsigned char* key, unsigned int length);

#endif



/*
 * ȡAirKiss汾Ϣ
 */
const char* airkiss_version(void);



/*
 * ʼAirKiss⣬ҪcontextԶε
 *
 * ֵ
 * 		< 0ͨǲ
 * 		  0ɹ
 */
int airkiss_init(airkiss_context_t* context, const airkiss_config_t* config);



/*
 * WiFi Promiscuous Mode󣬽յİairkiss_recvԽн
 *
 * ˵
 * 		frame802.11 frame mac header(must contain at least first 24 bytes)
 * 		lengthtotal frame length
 *
 * ֵ
 * 		 < 0ͨǲ
 * 		>= 0ɹοairkiss_status_t
 */
int airkiss_recv(airkiss_context_t* context, const void* frame, unsigned short length);



/*
 * airkiss_recv()AIRKISS_STATUS_COMPLETE󣬵ô˺ȡAirKiss
 *
 * ֵ
 * 		< 0״̬AIRKISS_STATUS_COMPLETE
 * 		  0ɹ
 */
int airkiss_get_result(airkiss_context_t* context, airkiss_result_t* result);


/*
 * ϲлŵԺ󣬿Եһ±ӿ建棬ŵĸʣעõ߼airkiss_init֮
 *
 * ֵ
 * 		< 0ͨǲ
 * 		  0ɹ
 */
int airkiss_change_channel(airkiss_context_t* context);

/*
 *
 * ʵAPI΢API
 *
 */

/*
 * airkiss_lan_recv()ķֵ
 */
typedef enum
{
	/* ṩݻȲ */
	AIRKISS_LAN_ERR_OVERFLOW = -5,

	/* ǰ汾ֵָ֧ */
	AIRKISS_LAN_ERR_CMD = -4,

	/* ݳ */
	AIRKISS_LAN_ERR_PAKE = -3,

	/* ݲ */
	AIRKISS_LAN_ERR_PARA = -2,

	/* ݴ */
	AIRKISS_LAN_ERR_PKG = -1,

	/* ĸʽȷǲҪ豸ݰ */
	AIRKISS_LAN_CONTINUE = 0,

	/* յ豸ݰ */
	AIRKISS_LAN_SSDP_REQ = 1,

	/* ݰ */
	AIRKISS_LAN_PAKE_READY = 2


} airkiss_lan_ret_t;


typedef enum
{
	AIRKISS_LAN_SSDP_REQ_CMD = 0x1,
	AIRKISS_LAN_SSDP_RESP_CMD = 0x1001,
	AIRKISS_LAN_SSDP_NOTIFY_CMD = 0x1002
} airkiss_lan_cmdid_t;

/*
 * 豸ģʽ󣬽յİairkiss_lan_recvԽн
 *
 * ˵
 * 		body802.11 frame mac header(must contain at least first 24 bytes)
 * 		lengthtotal frame length
 * 		configAirKissص
 *
 * ֵ
 * 		 < 0οairkiss_lan_ret_tͨǱݳ
 * 		>= 0ɹοairkiss_lan_ret_t
 */
int airkiss_lan_recv(const void* body, unsigned short length, const airkiss_config_t* config);

/*
 * 豸ҪЭʱñӿݰ
 *
 * ˵
 * 		body802.11 frame mac header(must contain at least first 24 bytes)
 * 		lengthtotal frame length
 * 		configAirKissص
 *
 * ֵ
 * 		 < 0οairkiss_lan_ret_tͨǱݳ
 * 		>= 0ɹοairkiss_lan_ret_t
 */
int airkiss_lan_pack(airkiss_lan_cmdid_t ak_lan_cmdid, void* appid, void* deviceid, void* _datain, unsigned short inlength, void* _dataout, unsigned short* outlength, const airkiss_config_t* config);

#ifdef __cplusplus
}
#endif

#endif /* AIRKISS_H_ */
