#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include "../../include/basetype.h"
#include "../include/socket.h"
#include "../include/debug.h"
#include "../include/scm.h"
#include "../include/iwifi_config.h"

#define SCM_LIB_RCV_TIME_OUT	5

int scm_set_running(void)
{
	pid_t stPid;
	SCM_EVENT_S stEvent;
	int iRet = ERROR_FAILED;

	memset(&stEvent, 0, sizeof(SCM_EVENT_S));

	stPid = getpid();
	stEvent.enMsgType = SCM_MSG_SET_STATE;
	stEvent.enState = SCM_STATE_RUNNING;
	stEvent.stPid = stPid;

	iRet = udp_send("127.0.0.1", SCM_LOCAL_PORT, &stEvent, sizeof(SCM_EVENT_S));
	if (ERROR_SUCCESS != iRet)
	{
		debug_print(DEBUG_TYPE_ERROR, "%d failed to set running", stPid);
	}

	return iRet;
}

SCM_STATE_E scm_get_state(IN const char *szServiceName)
{
	pid_t stPid;
	SCM_EVENT_S stEvent;
	int iRet = ERROR_FAILED;

	memset(&stEvent, 0, sizeof(SCM_EVENT_S));

	stEvent.enMsgType = SCM_MSG_GET_STATE;
	strcpy(stEvent.szName, szServiceName);

	iRet = udp_send_and_rcv_timeout(SCM_LIB_RCV_TIME_OUT, "127.0.0.1", SCM_LOCAL_PORT, &stEvent, sizeof(SCM_EVENT_S), NULL, NULL, NULL, NULL);
	if (ERROR_SUCCESS != iRet)
	{
		debug_print(DEBUG_TYPE_ERROR, "failed to get %s 's state", szServiceName);
	}
	else
	{
		iRet = stEvent.enState;
	}

	return iRet;
}

