#ifndef __YC_QUEUE_H__
#define __YC_QUEUE_H__

/***************************************************************
 *                    вӿ                             *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2015 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/

#define YC_QUEUE_NAME_LEN_MAX      32

typedef struct tagQueue_Info{
    char szNmae[YC_QUEUE_NAME_LEN_MAX];
    int iFd;
    uint uiUsed;
    uint uiSize;
}YC_QUEUE_INFO_S;


/*****************************************************************************
   (Prototype)    : yc_queue_create
 (Description)  : , һļ
 (Input)        : pcName          ƣΪ
                          uiSize          пɽϢĿΪ0
 (Output)       : (None)
   ֵ(Return Value) : int        >=0    ɹ(success)
                                      <0    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_queue_create(IN const char *pcName, IN uint uiSize);

/*****************************************************************************
   (Prototype)    : yc_queue_read
 (Description)  : 
 (Input)        : iFd          ļ
 (Output)       : pData        ȡϢ
                          puiLen       ϢС
   ֵ(Return Value) : int   YC_ERROR_SUCCESS    ɹ(success)
                                other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_queue_read(IN int iFd, OUT void *pData, OUT uint *puiLen);

/*****************************************************************************
   (Prototype)    : yc_queue_read_by_name
 (Description)  : УʱΪյĶвܵ
 (Input)        : pcName       
 (Output)       : pData        ȡϢ
                          puiLen       ϢС
   ֵ(Return Value) : int   YC_ERROR_SUCCESS    ɹ(success)
                                other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_queue_read_by_name(IN const char *pcName, OUT void *pData, OUT uint *puiLen);

/*****************************************************************************
   (Prototype)    : yc_queue_write
 (Description)  : д
 (Input)        : iFd          ļ
                          pData        Ҫ͵Ϣ
                          uiLen        ϢС
 (Output)       : (None)
   ֵ(Return Value) : int   YC_ERROR_SUCCESS    ɹ(success)
                                other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_queue_write(IN int iFd, IN const void *pData, IN uint uiLen);

/*****************************************************************************
   (Prototype)    : yc_queue_write_by_name
 (Description)  : дУʱΪյĶвܵ
 (Input)        : pcName       
                          pData        Ҫ͵Ϣ
                          uiLen        ϢС
 (Output)       : (None)
   ֵ(Return Value) : int   YC_ERROR_SUCCESS    ɹ(success)
                                other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_queue_write_by_name(IN const char *pcName, IN const void *pData, IN uint uiLen);

/*****************************************************************************
   (Prototype)    : yc_queue_destroy
 (Description)  : ٶ
 (Input)        : iFd          ļ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_queue_destroy(IN int iFd);

/*****************************************************************************
   (Prototype)    : yc_queue_destroy_by_name
 (Description)  : ٶУʱΪյĶвܵ
 (Input)        : pcName       
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_queue_destroy_by_name(IN const char *pcName);

/*****************************************************************************
   (Prototype)    : yc_queue_get_info
 (Description)  : ȡϢ
 (Input)        : iFd          ļ
 (Output)       : pstInfo      Ϣ
   ֵ(Return Value) : int   YC_ERROR_SUCCESS    ɹ(success)
                                other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_queue_get_info(IN int iFd, OUT YC_QUEUE_INFO_S *pstInfo);

/*****************************************************************************
   (Prototype)    : yc_queue_get_info_by_name
 (Description)  : ȡϢʱΪյĶвܵ
 (Input)        : pcName       
 (Output)       : pstInfo      Ϣ
   ֵ(Return Value) : int   YC_ERROR_SUCCESS    ɹ(success)
                                other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/9/7
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_queue_get_info_by_name(IN const char *pcName, OUT YC_QUEUE_INFO_S *pstInfo);

#endif /* __YC_QUEUE_H__ */

